/*  Berechnet den Standardwert für das Ende des Zeitfensters für die Ausschaltzeiten.

    Das Zeitfenster der Ausschalten sollen für alle KSVBA-Ressourcen gleich sein. Damit lassen sich AGe immer ohne Fehler von
    einer Ressource auf eine andere verschieben.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__renew_offtime', 'scheduling', _commit => true );  -- Funktion resource_timeline__offtime__default_timeframe_end__get() ist abhängig von Funktion resource_timeline__renew_offtime().
SELECT tsystem.function__drop_by_regex( 'resource_timeline__offtime__default_timeframe_end__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__offtime__default_timeframe_end__get(
  ) RETURNS timestamp AS $$

  DECLARE
      _max_ag_end                 timestamp;                                                                                      -- Ende des spätesten AG.
      _min_buffer_days_in_future  constant integer := TSystem.Settings__GetInteger( 'scheduling.min_buffer_days_in_future', 90 ); -- Ausschaltzeiten sollen immer mindestens 6 Monate nach Ende des spätesten AG in die Zukunft existieren.
      _min_days_in_future         constant integer := TSystem.Settings__GetInteger( 'scheduling.min_days_in_future', 730 );       -- Ausschaltzeiten sollen immer mindestens 2 Jahre in die Zukunft existieren.
      _result                     timestamp;                                                                                      -- Das Ergebnis.

  BEGIN
      -- Den Ende des spätesten AG in der Timeline finden.
      _max_ag_end := max( ti_date_end )
                FROM scheduling.resource_timeline
               WHERE ti_a2_id IS NOT null;

      _result :=
          greatest  (
                        date_trunc( 'day', _max_ag_end ) - interval '1 day' * _min_buffer_days_in_future    -- Entweder bis 6 Monate nach Ende des spätesten AG in die Zukunft oder ...
                      , date_trunc( 'day', now() ) + interval '1 day' * _min_days_in_future                 -- ... bis 2 Jahre von heute in die Zukunft sollen Ausschaltzeiten generiert werden. ...
                    )                                                                                       -- ... Je nachdem, was größer (weiter in Zukunft) ist.
      ;

      RETURN _result;

  END $$ language plpgsql;